package gov.va.med.mhv.mrp.data.model;

import java.io.Serializable;
import javax.persistence.*;

@Entity
@Table(name="MYGOALS_TASK_EXTENSIONS")
@NamedQuery(name="MyGoalsTaskExtensions.findAll", query="SELECT m FROM MyGoalsTaskExtensions m")
public class MyGoalsTaskExtensions implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="TASK_EXTENSION_ID")
	private Long taskExtensionId;

	private String description;

	@Version
	private Integer oplock;

	@Column(name="TASK_EXTENSION_TYPE")
	private Integer taskExtensionType;

	//bi-directional many-to-one association to MyGoalsTasks
	@ManyToOne
	@JoinColumn(name="TASK_ID")
	private MyGoalsTasks myGoalsTask;

	public MyGoalsTaskExtensions() {
	}

	public Long getTaskExtensionId() {
		return this.taskExtensionId;
	}

	public void setTaskExtensionId(Long taskExtensionId) {
		this.taskExtensionId = taskExtensionId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getOplock() {
		return this.oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getTaskExtensionType() {
		return this.taskExtensionType;
	}

	public void setTaskExtensionType(Integer taskExtensionType) {
		this.taskExtensionType = taskExtensionType;
	}

	public MyGoalsTasks getMyGoalsTask() {
		return this.myGoalsTask;
	}

	public void setMyGoalsTask(MyGoalsTasks myGoalsTask) {
		this.myGoalsTask = myGoalsTask;
	}

	@Override
	public String toString() {
		return "MyGoalsTaskExtensions [taskExtensionId=" + taskExtensionId + ", description=" + description + ", oplock=" + oplock + ", taskExtensionType="
				+ taskExtensionType + ", myGoalsTask=" + myGoalsTask + "]";
	}

	
}